/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpTestSDKIntegrity.c,v 1.5 2000/05/04 17:18:26 hal Exp $
____________________________________________________________________________*/
#include "pgpEncode.h"
#include "pgpErrors.h"
#include "pgpFIPSPriv.h"
#include "pgpKeys.h"
#include "pgpUtilities.h"
#include "pgpMem.h"

#if PGP_MACINTOSH
#include "MacStrings.h"

FSSpec		gPGPsdkLibFSSpec;
#elif PGP_WIN32
#include <windows.h>
HINSTANCE	gPGPsdkLibInst;
#endif

static const char sVerificationKey[] =
"-----BEGIN PGP PUBLIC KEY BLOCK-----\r\n"
"Version: PGP Personal Privacy 6.0.2\r\n"
"\r\n"
"mQGiBDZlyRARBADFK/xNtkCeYiZUdrQn+VL0GD9AUYClVWRMW0AQ8wY42qxaIqrV\r\n"
"WsQkfyye1uIktaACCdUqsGzYfFzjgu1VZKJBlDLc2/2d3m2VHVyAbhli/GcsDUHB\r\n"
"o9TG1wOxjkP3SBmVl/V18j75R+s9IquIohVaYARBK3fAJE5t7s7o0lNwQwCg/6ma\r\n"
"iAOUXF8XvZnZ4xPPnL1mLqcEAJi0uC1fRFUjr5aCov0QgfIDQLdNaBj4MTmoghCk\r\n"
"XOcMSSDgbFuNWnb4Wn0ZzkoOPQyok3CbLS5CHrc9+z5Rxo+AmYPTVwlMLPs13nz1\r\n"
"aEZGUyYyAWl+rMcpBgaJmtnlkTykPmWcKXt5efmZsqs4tIW+rIt6OGofHOcm5nPH\r\n"
"ZTsZA/45Y6MvrNzAeQcX2n79WeU1ATfQitkcAv8emM7+QIO+FvZRwhJVMy2m3IEw\r\n"
"yeBIcsmn7PUE1Q1w0DfAj8aRuLHgqLu7FcAjClJkOMadaeZkFk78GyI4vSOfL8bk\r\n"
"RQUC6g5XKdCp5BnX9D8NzSaff6sUVHx4M8nWeZdDfhjOvInT/bQhUEdQc2RrIDEu\r\n"
"NSBGSVBTIENlcnRpZmljYXRpb24gS2V5iQBLBBARAgALBQI2ZckQBAsDAgEACgkQ\r\n"
"jl9XAqkT8sFL9gCfcMPDYnDIjQ5Dw5SshU+teyXiHIQAoNiijNX0DAAVCFe3truj\r\n"
"YdOc8YGAuQINBDZlyRAQCAD2Qle3CH8IF3KiutapQvMF6PlTETlPtvFuuUs4INoB\r\n"
"p1ajFOmPQFXz0AfGy0OplK33TGSGSfgMg71l6RfUodNQ+PVZX9x2Uk89PY3bzpnh\r\n"
"V5JZzf24rnRPxfx2vIPFRzBhznzJZv8V+bv9kV7HAarTW56NoKVyOtQa8L9GAFgr\r\n"
"5fSI/VhOSdvNILSd5JEHNmszbDgNRR0PfIizHHxbLY7288kjwEPwpVsYjY67VYy4\r\n"
"XTjTNP18F1dDox0YbN4zISy1Kv884bEpQBgRjXyEpwpy1obEAxnIByl6ypUM2Zaf\r\n"
"q9AKUJsCRtMIPWakXUGfnHy9iUsiGSa6q6Jew1XpMgs7AAICCACAGfmD2nQPxMbr\r\n"
"X1tDrmmWrn4gxRPCtsUGimx6UTwzLxSGKXZr7mq+nZMZd0oYfpopP18St7iPAPBY\r\n"
"amSV6Lslu27VQHw1KQ+P8ek4BkOdY677jq3Rh+uib+np8TvVFZ2EMRqIR8XvpovZ\r\n"
"7y+p8UzjPZe/uY3uo2NbgbG9a08GPLdDWUaPVAFqtETcEJuABVZZmB95yHPCuNj+\r\n"
"pTBMKlssO5g1OeGd1yDpm6TorkXsvvAlNYFFRV8tYAjsvgnseA6gaKYXwASwCWMI\r\n"
"5ljQLBncKjWazVXF+ESVgjPPTMp7BhZ3xrJj8ON0e3jW8cwl83VsLu0anroQbUVf\r\n"
"lEG7VBqDiQBGBBgRAgAGBQI2ZckQAAoJEI5fVwKpE/LBSDMAoOdMGXhSDDqoU+9r\r\n"
"Wmv42xMHp1TsAJ9XI6yox0F58zloF4LUAEqlcF8wrQ==\r\n"
"=X+vG\r\n"
"-----END PGP PUBLIC KEY BLOCK-----\r\n";

#if PGP_MACINTOSH	/* [ */
/*
** On the Mac, the sig file which verifies the SDK is assumed to be in the
** same directory as the SDK and named <SDK Name>.sig
*/

	static PGPError
GetTestFileSpecs(
	PGPContextRef	context,
	PGPFileSpecRef	*libFileSpec,
	PGPFileSpecRef	*sigFileSpec)
{
	PGPError	err;
	FSSpec		sigFSSpec;
	
	*libFileSpec = kInvalidPGPFileSpecRef;
	*sigFileSpec = kInvalidPGPFileSpecRef;
	
	sigFSSpec = gPGPsdkLibFSSpec;
	if( sigFSSpec.name[0] > 27 )
		sigFSSpec.name[0] = 0;

	AppendPString( "\p.sig", sigFSSpec.name );
	
	err = PGPNewFileSpecFromFSSpec( context, &gPGPsdkLibFSSpec, libFileSpec );
	if( IsntPGPError( err ) )
	{
		err = PGPNewFileSpecFromFSSpec( context, &sigFSSpec, sigFileSpec );
		if( IsPGPError( err ) )
		{
			PGPFreeFileSpec( *libFileSpec );
			*libFileSpec = kInvalidPGPFileSpecRef;
		}
	}
	
	return( err );
}

#elif PGP_WIN32	/* ][ */

	static PGPError
GetTestFileSpecs(
	PGPContextRef	context,
	PGPFileSpecRef	*libFileSpec,
	PGPFileSpecRef	*sigFileSpec)
{
	PGPError	err = kPGPError_NoErr;
	char		libPath[MAX_PATH];
	char		sigPath[MAX_PATH];
	DWORD		libPathLength;

	libPathLength = GetModuleFileName( gPGPsdkLibInst, libPath, sizeof( libPath ) );
	if( libPathLength != 0 )
	{
		libPath[libPathLength] = 0;

		strcpy( sigPath, libPath );
		strcat( sigPath, ".sig" );

		err = PGPNewFileSpecFromFullPath( context, libPath, libFileSpec );
		if( IsntPGPError( err ) )
		{
			err = PGPNewFileSpecFromFullPath( context, sigPath, sigFileSpec );
			if( IsPGPError( err ) )
			{
				PGPFreeFileSpec( *libFileSpec );
				*libFileSpec = kInvalidPGPFileSpecRef;
			}
		}
	}
	else
	{
		err = kPGPError_FileNotFound;
	}

	return( err );
}

#else	/* ][ */

	static PGPError
GetTestFileSpecs(
	PGPContextRef	context,
	PGPFileSpecRef	*libFileSpec,
	PGPFileSpecRef	*sigFileSpec)
{
	(void) context;
	(void) libFileSpec;
	(void) sigFileSpec;
	return kPGPError_NoErr;
}

#endif	/* ] */

	static PGPError
DecodeEventHandlerProc(
	PGPContextRef 	context,
	PGPEvent 		*event,
	PGPUserValue 	userValue)
{
	PGPError	err = kPGPError_NoErr;
	
	(void) context;
	(void) userValue;
	
	switch( event->type )
	{
		case kPGPEvent_SignatureEvent:
		{
			if( event->data.signatureData.checked &&
				event->data.signatureData.verified )
			{
				/* Nothing. Sig is good */
			}
			else
			{
				err = kPGPError_BadSignature;
			}
			
			break;
		}
		default:
			break;
	}
	
	return( err );
}

/* FIPS140 state Run SW Integrity Test */
	PGPError
pgpTestSDKIntegrity(void)
{
	PGPError				err = kPGPError_NoErr;
	PGPContextRef			context;
	PGPCustomContextInfo	info;
	
#if PGP_UNIX
	/* UNIX self integrity tests are not implemented. Return success */
	return( kPGPError_NoErr );
#endif

	pgpClearMemory( &info, sizeof( info ) );
	
	info.sdkAPIVersion 	= kPGPsdkAPIVersion;
	info.memoryMgr		= PGPGetDefaultMemoryMgr();
	
	err = PGPNewContextCustom( &info, &context );
	if( IsntPGPError( err ) )
	{
		PGPKeyDBRef	keys;
		
		err = PGPImport( context, &keys,
				PGPOInputBuffer( context, sVerificationKey,
					sizeof( sVerificationKey ) ),
				PGPOLastOption( context ) );
		if( IsntPGPError( err ) )
		{
			PGPFileSpecRef	libFileSpec;
			PGPFileSpecRef	sigFileSpec;
			
			err = GetTestFileSpecs( context, &libFileSpec, &sigFileSpec );
			if( IsntPGPError( err ) )
			{
				err = PGPDecode( context,
						PGPOKeyDBRef( context, keys ),
						PGPOInputFile( context, sigFileSpec ),
						PGPODiscardOutput( context, TRUE ),
						PGPOEventHandler( context, DecodeEventHandlerProc, 0 ),
						PGPODetachedSig( context, 
							PGPOInputFile( context, libFileSpec ),
							PGPOLastOption( context ) ),
						PGPOLastOption( context ) );
						
				PGPFreeFileSpec( libFileSpec );
				PGPFreeFileSpec( sigFileSpec );
			}
			
			PGPFreeKeyDB( keys );
		}
	
		PGPFreeContext( context );
	}
	
	/*
	** For the purposes of a self-test, only kPGPError_SelfTestFailed is
	** ever returned as an error code.
	*/
	
	if( IsPGPError( err ) )
		err = kPGPError_SelfTestFailed;

	return( err );
}

